<?php

namespace AlloCine\SecureApiBundle\Tests\Api\Social;

use AlloCine\SecureApiBundle\Tests\Api\AbstractApiTestCase;
use AlloCine\SecureApiBundle\Api\Base\ApiDecoder;
use AlloCine\SecureApiBundle\Api\Social\ReviewApi;
use GuzzleHttp\Psr7\Response;

class ReviewApiTest extends AbstractApiTestCase
{
    public function testExecuteFromBuilder()
    {
        $api = $this->getApi('AlloCine\SecureApiBundle\Api\Social\ReviewApi', '{"id": 1, "title": "foo"}');

        $this->assertEquals((object)['id' => 1, 'title' => 'foo'], $api->executeFromBuilder(['subject' => 'movie:1']));
    }

    public function testGetReviewCountByRating()
    {
        $client = $this
            ->getMockBuilder('AlloCine\SecureApiBundle\Client\MultiRegionApiClient')
            ->disableOriginalConstructor()
            ->getMock()
        ;

        foreach (range(1, 5) as $i) {
            $client
                ->expects($this->at($i-1))
                ->method('get')
                ->with('reviewlist', [
                    'query' => [
                        'filter' => 'user',
                        'subject' => "movie:1",
                        'rating' => $i,
                        'page' => 1,
                        'count' => 0
                    ]
                ])
                ->willReturn(new Response(200, [], sprintf('{"feed": {"totalResults": %d}}', $i * 2)))
            ;
        }

        $api = new ReviewApi($client, new ApiDecoder());
        $this->assertSame([
            1 => 2,
            2 => 4,
            3 => 6,
            4 => 8,
            5 => 10,
        ], $api->getReviewCountByRating('user', 'movie', 1));
    }

    public function testGetReviews()
    {
        $api = $this->getApi('AlloCine\SecureApiBundle\Api\Social\ReviewApi', '[]');

        $this->assertSame([], $api->getReviews('user', 'movie', 1, 'helpful', 'asc', 0));
    }

    public function testGetReviewCount()
    {
        $api = $this->getApi('AlloCine\SecureApiBundle\Api\Social\ReviewApi', '{"feed": {"totalResults": 42 }}');

        $this->assertSame(42, $api->getReviewCount('user', 'movie', 1));
    }

    public function testGet()
    {
        $api = $this->getApi('AlloCine\SecureApiBundle\Api\Social\ReviewApi', '{"id": 1, "title": "foo"}', 'movie', [
            'query' => [
                'profile' => 'medium',
                'code' => 1
            ]
        ]);

        $this->assertEquals((object)['id' => 1, 'title' => 'foo'], $api->getMovieReviewsDetail(1));
    }
}
