<?php

namespace AlloCine\SecureApiBundle\Api\Wrapper;

use AlloCine\SecureApiBundle\Api\Secure\UserApi;

/**
 * Class SecureApiWrapper
 * @package AlloCine\SecureApiBundle\Api
 */

class SecureApiWrapper
{
    /**
     * @var string
     */
    private $token;

    /**
     * @var UserApi
     */
    private $userApi;

    /**
     * @param UserApi $reviewApi
     */
    public function __construct(UserApi $userApi)
    {
        $this->userApi = $userApi;
    }

    /**
     * Set User Token
     *
     * @param string $token
     */
    public function setToken($token)
    {
        $this->token = $token;
    }

    /**
     * @return UserApi
     */
    public function user()
    {
        return $this->userApi->setToken($this->token);
    }
}
