<?php

namespace AlloCine\SecureApiBundle\Api\Base;

use AlloCine\SecureApiBundle\Exception\ApiException;
use AlloCine\SecureApiBundle\Exception\NoResultException;
use GuzzleHttp\Psr7\Response;

class ApiDecoder
{
    /**
     * @param Response $response The guzzle response
     * @param string   $path     The path of the resource that generated the response.
     *
     * @throws NoResultException If there is no results
     * @throws ApiException If the API encounters an error.
     *
     * @return \stdClass
     */
    public function decode(Response $response, $path)
    {
        $content = $response->getBody()->getContents();
        $result = json_decode($content);

        if (is_null($result)) {
            throw new ApiException(sprintf("Unable to json_decode API for call \"%s\".\nResponse: \"%s\"", $path,
                $content));
        } elseif ($error = $this->decodeError($result)) {
            if (strpos($error, 'No result') !== false) {
                throw new NoResultException(sprintf('Api call "%s" returned no result', $path));
            } else {
                throw new ApiException(sprintf('Api call "%s" returned an error : %s', $path, $error));
            }
        }

        return $result;
    }

    /**
     * @param \stdClass|array $response
     *
     * @return string|null
     */
    private function decodeError($response)
    {
        if (!($response instanceof \stdClass) || !property_exists($response, 'error')) {
            return null;
        }

        if (property_exists($response->error, '$')) {
            return $response->error->{'$'};
        } elseif (property_exists($response->error, 'message')) {
            return $response->error->message;
        }

        return 'Unknown error.';
    }
}
