<?php

namespace AlloCine\SecureApiBundle\Tests\QueryBuilder;

use AlloCine\SecureApiBundle\Api\Standard\ShowtimeApi;
use AlloCine\SecureApiBundle\QueryBuilder\ShowtimeQueryBuilder;

class ShowtimeQueryBuilderTest extends \PHPUnit_Framework_TestCase
{
    public function testNominalCase()
    {
        $mock = $this->getShowtimeApiMock([
            'date'         => '2016-01-19',
            'display'      => 'digital',
            'distributors' => 'acme,doe',
            'lat'          => 1.22,
            'long'         => 1.33,
            'location'     => 'Toulouse',
            'membercard'   => 'lepass',
            'movie'        => 1,
            'order'        => 'asc',
            'radius'       => 10,
            'theaters'     => 'P001,P002',
            'zip'          => 31000,
            'oversion'     => '1',
            'triptime'     => 10,
            'timerange'    => 20,
            'page'         => 3,
            'count'        => 10
        ]);

        $builder = new ShowtimeQueryBuilder($mock);
        $builder
            ->setDate(new \DateTime('2016-01-19'))
            ->setDisplay('digital')
            ->setDistributors(['acme', 'doe'])
            ->setGeo(1.22, 1.33)
            ->setLocation('Toulouse')
            ->setMembercard('lepass')
            ->setMovie(1)
            ->setOrder('asc')
            ->setRadius(10)
            ->setTheaters(['P001', 'P002'])
            ->setZip(31000)
            ->useOriginalVersion()
            ->setTimerange(20)
            ->setTriptime(10)
            ->page(3)
            ->execute()
        ;
    }

    public function testPageOverflow()
    {
        $mock = $this->getShowtimeApiMock([
            'date'         => null,
            'display'      => null,
            'distributors' => null,
            'lat'          => null,
            'long'         => null,
            'location'     => null,
            'membercard'   => null,
            'movie'        => null,
            'order'        => null,
            'radius'       => null,
            'theaters'     => null,
            'zip'          => null,
            'oversion'     => null,
            'triptime'     => null,
            'timerange'    => null,
            'page'         => ShowtimeQueryBuilder::API_MAX_INT,
            'count'        => 10
        ]);

        $builder = new ShowtimeQueryBuilder($mock);
        $builder->page(ShowtimeQueryBuilder::API_MAX_INT + 1000);
        $builder->execute();
    }

    public function testNegativePage()
    {
        $mock = $this->getShowtimeApiMock([
            'date'         => null,
            'display'      => null,
            'distributors' => null,
            'lat'          => null,
            'long'         => null,
            'location'     => null,
            'membercard'   => null,
            'movie'        => null,
            'order'        => null,
            'radius'       => null,
            'theaters'     => null,
            'zip'          => null,
            'oversion'     => null,
            'triptime'     => null,
            'timerange'    => null,
            'page'         => 1,
            'count'        => 10
        ]);

        $builder = new ShowtimeQueryBuilder($mock);
        $builder->page(-10);
        $builder->execute();
    }

    public function testCallback()
    {
        $mock = $this->getShowtimeApiMock();
        $mock
            ->expects($this->once())
            ->method('executeFromBuilder')
            ->willReturn(new \stdClass)
        ;

        $passed = false;

        $builder = new ShowtimeQueryBuilder($mock);
        $builder->callback(function ($result) use (&$passed) {
            $passed = true;
            $this->assertEquals(new \stdClass, $result);
        });
        $builder->execute();

        $this->assertTrue($passed);
    }

    /**
     * @param null|array $expectedValues
     *
     * @return ShowtimeApi A mocked version of ShowtimeA pi
     */
    public function getShowtimeApiMock($expectedValues = null)
    {
        $mock = $this
            ->getMockBuilder('AlloCine\SecureApiBundle\Api\Standard\ShowtimeApi')
            ->disableOriginalConstructor()
            ->getMock()
        ;

        if ($expectedValues) {
            $mock
                ->expects($this->once())
                ->method('executeFromBuilder')
                ->with($expectedValues)
                ->willReturn(new \stdClass)
            ;
        }

        return $mock;
    }
}
