<?php

namespace AlloCine\SecureApiBundle\Api\Social;

use AlloCine\SecureApiBundle\Api\Base\AbstractApi;
use AlloCine\SecureApiBundle\Exception\NoResultException;

class CommentApi extends AbstractApi
{
    /**
     * @param int $idMovie
     * @return array
     */
    public function getMovieComment($idMovie)
    {
        try {
            $comments = $this->fetch(sprintf('comments/movie/%d', $idMovie));
        } catch (NoResultException $e) {
            $comments = [];
        }

        return $comments;
    }

    /**
     * @param int $idNews
     * @return array
     */
    public function getNewsComment($idNews)
    {
        try {
            $comments = $this->fetch(sprintf('comments/news/%d', $idNews));
        } catch (NoResultException $e) {
            $comments = [];
        }

        return $comments;
    }

    /**
     * @param int $idPerson
     * @return array
     */
    public function getPersonComment($idPerson)
    {
        try {
            $comments = $this->fetch(sprintf('comments/person/%d', $idPerson));
        } catch (NoResultException $e) {
            $comments = [];
        }

        return $comments;
    }

    /**
     * @param int $idSeries
     * @return array
     */
    public function getSeriesComment($idSeries)
    {
        try {
            $comments = $this->fetch(sprintf('comments/series/%d', $idSeries));
        } catch (NoResultException $e) {
            $comments = [];
        }

        return $comments;
    }

    /**
     * @param int $idSeason
     * @return array
     */
    public function getSeasonComment($idSeason)
    {
        try {
            $comments = $this->fetch(sprintf('comments/season/%d', $idSeason));
        } catch (NoResultException $e) {
            $comments = [];
        }

        return $comments;
    }

    /**
     * @param int $idEpisode
     * @return array
     */
    public function getEpisodeComment($idEpisode)
    {
        try {
            $comments = $this->fetch(sprintf('comments/episode/%d', $idEpisode));
        } catch (NoResultException $e) {
            $comments = [];
        }

        return $comments;
    }

    /**
     *
     * @param int $idMovie
     * @param int $idMedia
     * @return array
     */
    public function getMovieMediaComment($idMovie, $idMedia)
    {
        try {
            $comments = $this->fetch(sprintf('comments/movie/%d/%d', $idMovie, $idMedia));
        } catch (NoResultException $e) {
            $comments = [];
        }

        return $comments;
    }

    /**
     * @param int $idSeries
     * @param int $idMedia
     *
     * @return array
     */
    public function getSeriesMediaComment($idSeries, $idMedia)
    {
        try {
            $comments = $this->fetch(sprintf('comments/series/%d/%d', $idSeries, $idMedia));
        } catch (NoResultException $e) {
            $comments = [];
        }

        return $comments;
    }

    /**
     * @param int $idMovie
     * @return array
     */
    public function getMovieSoundtrackComment($idMovie)
    {
        try {
            $comments = $this->fetch(sprintf('comments/movie/%d/soundtrack', $idMovie));
        } catch (NoResultException $e) {
            $comments = [];
        }

        return $comments;
    }

    /**
     * @param int $idSeries
     * @return array
     */
    public function getSeriesSoundtrackComment($idSeries)
    {
        try {
            $comments = $this->fetch(sprintf('comments/series/%d/soundtrack', $idSeries));
        } catch (NoResultException $e) {
            $comments = [];
        }

        return $comments;
    }

    /**
     * @param int $idMovie
     *
     * @return array
     */
    public function getMovieEditorialReviewComment($idMovie)
    {
        try {
            $comments = $this->fetch(sprintf('comments/movie/%d/editorial-review', $idMovie));
        } catch (NoResultException $e) {
            $comments = [];
        }

        return $comments;
    }


    /**
     * @param int $idMedia
     * @return array
     */
    public function getMediaComment($idMedia)
    {
        try {
            $comments = $this->fetch(sprintf('comments/media/%d', $idMedia));
        } catch (NoResultException $e) {
            $comments = [];
        }

        return $comments;
    }

    /**
     * @param int $idProgram
     * @return array
     */
    public function getProgramComment($idProgram)
    {
        try {
            $comments = $this->fetch(sprintf('comments/program/%d', $idProgram));
        } catch (NoResultException $e) {
            $comments = [];
        }

        return $comments;
    }
}
