<?php

namespace AlloCine\SecureApiBundle\Api\Base;

use AlloCine\SecureApiBundle\Client\MultiRegionApiClient;
use AlloCine\SecureApiBundle\Exception\ApiException;

/**
 * Class Api
 * @package AlloCine\SecureApiBundle\Api
 */
class AbstractApi
{
    /**
     * @var MultiRegionApiClient
     */
    protected $client;

    /**
     * @var ApiDecoder
     */
    protected $decoder;

    /**
     * @param MultiRegionApiClient $client
     * @param ApiDecoder           $decoder
     */
    public function __construct(MultiRegionApiClient $client, ApiDecoder $decoder)
    {
        $this->client = $client;
        $this->decoder = $decoder;
    }

    /**
     * @param string $path
     * @param array  $query
     *
     * @return \stdClass
     */
    protected function fetch($path, array $query = [])
    {
        try {
            return $this->decoder->decode($this->client->get($path, ['query' => $query]), $path);
        } catch (\GuzzleHttp\Exception\ServerException $e ) {
            throw new ApiException();
        }
    }
}
