<?php

namespace AlloCine\SecureApiBundle\Tests\QueryBuilder;

use AlloCine\SecureApiBundle\Api\Standard\TheaterApi;
use AlloCine\SecureApiBundle\QueryBuilder\TheaterQueryBuilder;

class TheaterQueryBuilderTest extends \PHPUnit_Framework_TestCase
{
    public function testNominalCase()
    {
        $mock = $this->getTheaterApiMock([
            'count'      => 10,
            'display'    => 'digital',
            'filter'     => 'lastupdated',
            'from'       => '2016-01-19',
            'geocode'    => 123,
            'lat'        => 1.22,
            'location'   => 'Toulouse',
            'long'       => 1.33,
            'membercard' => 'lepass',
            'oversion'   => '1',
            'radius'     => 10,
            'theater'    => 'P001,P002',
            'zip'        => 31300
        ]);

        $builder = new TheaterQueryBuilder($mock);
        $builder
            ->setDisplay('digital')
            ->setFilter('lastupdated')
            ->setFrom(new \DateTime('2016-01-19'))
            ->setGeocode(123)
            ->setLocation('Toulouse')
            ->setGeo(1.22, 1.33)
            ->setMembercard('lepass')
            ->useOriginalVersion()
            ->setRadius(10)
            ->setTheaters(['P001', 'P002'])
            ->setZip(31300)
            ->execute()
        ;
    }

    public function testCallback()
    {
        $mock = $this->getTheaterApiMock();
        $mock
            ->expects($this->once())
            ->method('executeFromBuilder')
            ->willReturn(new \stdClass)
        ;

        $passed = false;

        $builder = new TheaterQueryBuilder($mock);
        $builder->callback(function ($result) use (&$passed) {
            $passed = true;
            $this->assertEquals(new \stdClass, $result);
        });
        $builder->execute();

        $this->assertTrue($passed);
    }

    /**
     * @param null|array $expectedValues
     *
     * @return TheaterApi A mocked version of TheaterApi
     */
    public function getTheaterApiMock($expectedValues = null)
    {
        $mock = $this
            ->getMockBuilder('AlloCine\SecureApiBundle\Api\Standard\TheaterApi')
            ->disableOriginalConstructor()
            ->getMock()
        ;

        if ($expectedValues) {
            $mock
                ->expects($this->once())
                ->method('executeFromBuilder')
                ->with($expectedValues)
                ->willReturn(new \stdClass)
            ;
        }

        return $mock;
    }
}
