<?php

namespace AlloCine\SecureApiBundle\Tests\Api\Base;

use AlloCine\SecureApiBundle\Api\Base\ApiDecoder;
use GuzzleHttp\Psr7\Response;

class ApiDecoderTest extends \PHPUnit_Framework_TestCase
{
    public function testValidResponse()
    {
        $response = new Response(200, [], '{"resultset":[],"count":0}');

        $decoder = new ApiDecoder();
        $decoder->decode($response, '/foo');
    }

    public function testValidArrayResponse()
    {
        $response = new Response(200, [], '[{"resultset":[],"count":0}]');

        $decoder = new ApiDecoder();
        $this->assertSame(0, $decoder->decode($response, '/foo')[0]->count);
    }

    /**
     * @expectedException AlloCine\SecureApiBundle\Exception\NoResultException
     * @expectedExceptionMessage Api call "/foo" returned no result
     */
    public function testNoResultResponse()
    {
        $response = new Response(200, [], '{"error":{"code":0,"$":"No results."}}');

        $decoder = new ApiDecoder();
        $decoder->decode($response, '/foo');
    }

    /**
     * @expectedException AlloCine\SecureApiBundle\Exception\ApiException
     * @expectedExceptionMessage Api call "/foo" returned an error : It failed for any reason.
     */
    public function testErrorResponse()
    {
        $response = new Response(200, [], '{"error":{"code":0,"$":"It failed for any reason."}}');

        $decoder = new ApiDecoder();
        $decoder->decode($response, '/foo');
    }

    /**
     * @expectedException AlloCine\SecureApiBundle\Exception\ApiException
     * @expectedExceptionMessage Api call "/foo" returned an error : It failed for any reason.
     */
    public function testAlternativeErrorResponse()
    {
        $response = new Response(200, [], '{"error":{"code":0,"message":"It failed for any reason."}}');

        $decoder = new ApiDecoder();
        $decoder->decode($response, '/foo');
    }

    /**
     * @expectedException AlloCine\SecureApiBundle\Exception\ApiException
     * @expectedExceptionMessage Api call "/foo" returned an error : Unknown error.
     */
    public function testUnknownErrorResponse()
    {
        $response = new Response(200, [], '{"error":{"code":0}}');

        $decoder = new ApiDecoder();
        $decoder->decode($response, '/foo');
    }

    /**
     * @expectedException AlloCine\SecureApiBundle\Exception\ApiException 
     * @expectedExceptionMessage Unable to json_decode API for call "/foo".
     * @expectedExceptionMessage Response: "{bar : malformed}"
     */
    public function testMalformedResponse()
    {
        $response = new Response(200, [], '{bar : malformed}');

        $decoder = new ApiDecoder();
        $decoder->decode($response, '/foo');
    }
}
