<?php

namespace AlloCine\SecureApiBundle\Api\Wrapper;

use AlloCine\SecureApiBundle\Api\Social\ReviewApi;
use AlloCine\SecureApiBundle\Api\Social\CommentApi;

/**
 * Class SocialApiWrapper
 * @package AlloCine\SecureApiBundle\Api\Wrapper
 */
class SocialApiWrapper
{
    /**
     * @var ReviewApi
     */
    private $reviewApi;

    /**
     * @var CommentApi
     */
    private $commentApi;

    /**
     * @param ReviewApi $reviewApi
     */
    public function __construct(
        ReviewApi $reviewApi,
        CommentApi $commentApi
    ) {
        $this->reviewApi = $reviewApi;
        $this->commentApi = $commentApi;
    }

    /**
     * @return ReviewApi
     */
    public function reviews()
    {
        return $this->reviewApi;
    }

    /**
     * @return CommentApi
     */
    public function comment()
    {
        return $this->commentApi;
    }
}
