<?php

namespace AlloCine\SecureApiBundle;

use Symfony\Component\HttpKernel\Bundle\Bundle;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use AlloCine\SecureApiBundle\DependencyInjection\AlloCineSecureApiExtension;
use AlloCine\SecureApiBundle\DependencyInjection\CompilerPass\CollectorPass;

class AlloCineSecureApiBundle extends Bundle
{
    /**
     * Override config name
     *
     * @return AlloCineSecureApiExtension
     */
    public function getContainerExtension()
    {
        return new AlloCineSecureApiExtension();
    }

    public function build(ContainerBuilder $container)
    {
        parent::build($container);

        if ($container->getParameter('kernel.debug') === true) {
            $container->addCompilerPass(new CollectorPass());
        }
    }
}
