<?php

namespace Allocine\Routing;

use Symfony\Component\Routing\Exception\InvalidParameterException;
use Symfony\Component\Routing\Generator\UrlGenerator as BaseUrlGenerator;

class UrlGenerator extends BaseUrlGenerator
{
    protected function doGenerate($variables, $defaults, $requirements, $tokens, $parameters, $name, $referenceType, $hostTokens, array $requiredSchemes = array())
    {
        $fragments = [];
        $removedVariables = [];

        if ($defaults['_mapping'] ?? false) {
            foreach ($defaults['_mapping'] as $field => $mapping) {
                // Ignore non-existent parameters.
                if (!array_key_exists($field, $parameters)) {
                    continue;
                }

                $oldValue = $parameters[$field] ?? null;

                // If there is no mapping available throw an error or generate if forced too.
                if (!array_key_exists($oldValue, $mapping)) {
                    if($this->isStrictRequirements()) {
                        throw new InvalidParameterException(sprintf(
                            'Parameter "%s" is mapped and should be in %s ("%s" given).',
                            $field,
                            implode(', ', array_keys($mapping)),
                            $oldValue
                        ));
                    }

                    $parameters[$field] = $oldValue;
                } else {
                    $parameters[$field] = $mapping[$oldValue];
                }

                // If the value is empty after mapping, remove it.
                if (!$parameters[$field]) {
                    unset($parameters[$field]);
                }
            }
        }

        foreach ($tokens as $token) {
            if ($token[0] === 'part') {
                $fragment = '';
                $omit = true;

                foreach ($token[2] as $subToken) {
                    if ($subToken[0] === 'text') {
                        $fragment = $subToken[1].$fragment;
                    } else {
                        if (array_key_exists($subToken[3], $parameters)) {
                            if ($this->isStrictRequirements() && !preg_match('#^'.$subToken[2].'$#', $parameters[$subToken[3]])) {
                                $message = sprintf('Parameter "%s" for route "%s" must match "%s" ("%s" given) to generate a corresponding URL.', $subToken[3], $name, $subToken[2], $parameters[$subToken[3]]);
                                throw new InvalidParameterException($message);
                            }

                            $fragment = $subToken[1].$parameters[$subToken[3]].$fragment;
                            $omit = false;
                            unset($parameters[$subToken[3]]);
                        }

                        $removedVariables[]= $subToken[3];
                    }

                }

                $fragments[$token[1]] = $omit ? '' : $fragment;
            }
        }

        $variables = array_diff($variables, $removedVariables);

        $url = parent::doGenerate($variables, $defaults, $requirements, $tokens, $parameters, $name, $referenceType, $hostTokens, $requiredSchemes);

        foreach ($fragments as $placeholder => $replacement) {
            $url = str_replace($placeholder, $replacement, $url);
        }

        return $url;
    }
}
