# Allociné's Custom Routing Component

This is a custom routing component specifically designed to handle AlloCiné's edge cases.

It introduces two new features : parameter mapping and optional url parts.

## Installation

Add the component `allocine/routing` to your `composer.json`.

**In the Symfony standard edition**, change Symfony's default `UrlMatcher` and `UrlGenerator` :

```yml
#config.yml
parameters:
    router.options.generator_class: Allocine\Routing\UrlGenerator
    router.options.generator_base_class: Allocine\Routing\UrlGenerator
    router.options.matcher_base_class: Allocine\Routing\UrlMatcher
    router.options.matcher_class: Allocine\Routing\UrlMatcher
```

**If using the component as a standalone**, just use `Allocine\Routing\UrlMatcher` and `Allocine\Routing\UrlGenerator`
instead of the default one from `symfony/routing`.

## Usage

### Optional parts

The main goal is to declare a route where some parts of the url can be completely omitted. For instance,
we want to plug to the same controller the following urls :

- /movies/bests
- /movies/bests/decade-2010
- /movies/bests/category-1012/decade-2010

Using this component, here is the declaration needed :

```yaml
movies:
    path: /movies/bests[/category-{category}][/decade-{decade}]
    requirements:
        category: "[0-5]+"
        decade: "[1-9]{4}"
    options:
        # Don't forget this or the [] syntax won't be handled !
        compiler_class: Allocine\Routing\FilteredRouteCompiler
```

You can also provide default values for the optional pars using the good old `default` mechanism of Symfony.

If an optional variable is not provided and no default is declared, its value will be `null`.

### Parameter mapping

The goal of this feature is to allow declarative, on the fly, parameter mapping. For instance, we have
the following urls :

- /movies/bests
- /movies/worsts
- /movies/peoples-like-it

The last part of the url only changes the order of the movies, so 99% of the code of our controllers would
be the same, let's make a single controller with a single route for this : we would use a pattern like
`/movies/{order}`.

But in our model, our orders are named `best_ratings`, `worst_ratings` and `most_popular`. Let's use parameter
mapping !

```yaml
movies:
    path: /movies/{order}
    requirements:
        order: "([a-z\\-\\_]+)"
    defaults:
        _controller: AppBundle:Movies:filter
        _mapping:
            order:
                best_ratings: bests
                worst_ratings: worsts
                most_popular: peoples-like-it
```

With this configuration, in our controller, `$order` will have the model values. But even better : when we will
generate urls, we will use the model values and get the correct url :

```twig
{{ path('movies', { order: 'most_popular' }) }} {# Outputs /movies/peoples-like-it #}
```
