<?php

namespace Allocine\Routing;

use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Exception\ResourceNotFoundException;
use Symfony\Component\Routing\Matcher\RedirectableUrlMatcher;
use Symfony\Component\Routing\Route;

class UrlMatcher extends RedirectableUrlMatcher
{
    protected function mergeDefaults($params, $defaults) {
        if ($defaults['_mapping'] ?? false) {
            foreach ($defaults['_mapping'] as $field => $mapping) {
                $mapping = array_flip($mapping);
                $oldValue = $params[$field] ?? null;

                if (isset($mapping[$oldValue])) {
                    $params[$field] = $mapping[$oldValue] ?? null;
                } elseif ($oldValue) {
                    throw new ResourceNotFoundException(sprintf(
                        'Parameter "%s" is not valid (must be in %s)',
                        $field,
                        implode(', ', array_keys($mapping))
                    ));
                }
            }
        }

        return parent::mergeDefaults(array_filter($params, function ($v) {
            return $v !== '';
        }), $defaults);
    }

    /**
     * {@inheritdoc}
     */
    public function redirect($path, $route, $scheme = null) {
        $url = $this->getContext()->getBaseUrl().$path;
        $queryString = $this->getContext()->getQueryString();
        if ($queryString) {
            if (false === strpos($path, '?')) {
                $queryString = '?'.$queryString;
            } else {
                $queryString = '&'.$queryString;
            }
        }
        if (null === $scheme) {
            $scheme = $this->getContext()->getScheme();
        }
        $port = '';
        if ('http' === $scheme && 80 != $this->getContext()->getHttpPort()) {
            $port = ':'.$this->getContext()->getHttpPort();
        } elseif ('https' === $scheme && 443 != $this->getContext()->getHttpsPort()) {
            $port = ':'.$this->getContext()->getHttpsPort();
        }
        $url = $scheme.'://'.$this->getContext()->getHost().$port.$url.$queryString;
        return [
            '_controller' => function($url) {return new RedirectResponse($url, Response::HTTP_MOVED_PERMANENTLY);},
            '_route' => $route,
            'url' => $url
        ];
    }
}
