<?php

namespace App\Command;

use App\Common\NotifierInterface;
use App\Configuration;
use App\Service\InitMq;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;
use Symfony\Component\Yaml\Yaml;

class InitMqCommand extends Command implements NotifierInterface
{
    /**
     * @var InitMq
     */
    private $initMq;

    /**
     * @var array
     */
    private $configs;

    /**
     * @var SymfonyStyle
     */
    private $io;

    /**
     * @param InitMq $initMq
     * @param array $configs
     */
    public function __construct(InitMq $initMq, array $configs)
    {
        $this->initMq = $initMq;
        $this->configs = $configs;

        parent::__construct();
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     */
    public function initialize(InputInterface $input, OutputInterface $output)
    {
        $this->io = new SymfonyStyle($input, $output);
    }

    /**
     * {@inheritdoc}
     */
    protected function configure()
    {
        $this
            ->setName('pgs:mq:init')
            ->setAliases(['mq:init'])
            ->setDescription('Creates all exchanges and queues in rabbitMQ and ES index to store bad messages.')
            ->addOption(
                'file',
                'f',
                InputOption::VALUE_REQUIRED,
                'Configuration file'
            )
        ;
    }

    /**
     * {@inheritdoc}
     *
     * @param InputInterface  $input
     * @param OutputInterface $output
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->initMq->launch($this->configs, $this);
    }

    /**
     * @param string $message
     */
    public function notify(string $message)
    {
        $this->io->writeln($message);
    }
}
