# Postgresql streamer

Utilisé pour brancher un slot de réplication PG, lire ce slot et envoyer le contenu dans un MQ ou un PUBSUB.

Pour activer le reverse proxy : Aller dans dev-env

`./init.sh`

Verifier que Traetik soit actif : http://localhost

## MQ

Pour envoyer des messages vers un MQ, le postgresql-streamer a besoin de :

- PG
- rabbitMQ

Aller sur le projet dbz:

```bash
make up
make install
make mq-up
make mq-haproxy-up
cd common/postgresql-streamer
make login docker-stack release
```

Vérifier sur Traefik dashboard the backend-rabbitmq-node1-dbz-http and et sur l'interface d'adm de Rabbit MQ http://dev-rabbitmq.dbz.local.allocine.net

user:user
password:password

make release crée un exécutable `bin/postgresql-streamer.phar`

Dans le répertoire `common/postgresql-streamer`, il faut :

```bash
make sh
```

Ensuite lancer le phar :

```bash
#init
PGS_RABBITMQ_URI="amqp://mq_user:mq_pass@haproxy:5672//mq_dbz_vhost" \
PGS_PG_DSN="pgsql://dbz_rw@postgres:5432/dbz" \
PGS_PROJECT_NAME=dbz \
PGS_SLOT_TABLES=social.* bin/postgresql-streamer \
pgs:mq:init

#wal parser
PGS_RABBITMQ_URI="amqp://mq_user:mq_pass@haproxy:5672//mq_dbz_vhost" \
PGS_PG_DSN="pgsql://dbz_rw@postgres:5432/dbz" \
PGS_PROJECT_NAME=dbz \
PGS_SLOT_TABLES=social.* bin/postgresql-streamer \
pgs:parse:mq
```

## PUBSUB

Pour envoyer des messages vers un PUBSUB, le postgresql-streamer a besoin de :

- PG
- Google PUBSUB credentials

Aller sur le projet dbz:

```bash
make up
make install
cd common/postgresql-streamer
make login docker-stack release
make sh
```

Ensuite lancer le phar :

```bash
PGS_PG_DSN="pgsql://dbz_rw@postgres:5432/dbz" \
PGS_PROJECT_NAME=dbz \
PGS_TOPIC_NAME=pgstreamer1 \
PGS_PUBSUB_CREDENTIALS=<key-pub-sub.json> \
PGS_SLOT_TABLES=movie.* \
bin/postgresql-streamer pgs:parse:pubsub
```

Pour utiliser l'emulateur PUBSUB inclus dans le projet, il faut :

`docker-composer up`
Lancer le phar en ajoutant la variable d'environnement
`PUBSUB_EMULATOR_HOST=pubsub:8085`

## Nettoyage

Pour nettoyer : (remplacer project_name par le nom du projet du slot à nettoyer, par exemple pour le slot "dbz_wal_parser" le project_name est dbz)

```bash
PGS_PG_DSN="pgsql://dbz_rw@postgres:5432/dbz" \
PGS_PROJECT_NAME={project_name} \
PGS_SLOT_TABLES=social.* bin/postgresql-streamer \
pgs:wal:drop-slot
```
