<?php

namespace App\Service\Publisher;

use Google\Cloud\PubSub\Message;
use Google\Cloud\PubSub\PubSubClient;

class PubSubPublisher implements PublisherInterface
{
    /**
     * @var PubSubClient
     */
    private $client;

    /**
     * @var string
     */
    private $topic;

    /**
     * @var string
     */
    private $keyFilePath;

    public function __construct(string $topic, string $keyFilePath)
    {
        $this->topic = $topic;
        $this->keyFilePath = $keyFilePath;
    }

    public function publish(\stdClass $walChange): void
    {
        $topic = $this->getClient()->topic($this->topic);

        $msg = new Message(['data' => json_encode($walChange)]);
        $topic->publish($msg);
    }

    private function getClient(): PubSubClient
    {
        if ($this->client instanceof PubSubClient) {
            return $this->client;
        }

        return new PubSubClient(['keyFilePath' => $this->keyFilePath]);
    }
}
