<?php

namespace App\Command;

use App\Common\Constant;
use App\Service\Slot;
use Psr\Log\LoggerInterface;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class DropSlotCommand extends Command
{
    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @var Slot
     */
    private $slotService;


    public function __construct(LoggerInterface $logger, Slot $slotService)
    {
        $this->logger = $logger;
        $this->slotService = $slotService;

        parent::__construct();
    }

    /**
     * {@inheritdoc}
     */
    protected function configure()
    {
        $this
            ->setName('pgs:wal:drop-slot')
            ->setDescription('Kill the active slot PID and drop the current PG replication slot.')
        ;
    }

    /**
     * {@inheritdoc}
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->logger->notice('Started {component}', [
            'component' => Constant::MQ_COMPONENT_NAME,
            'slot'      => $this->slotService->getSlotName()
        ]);

        try {
            $this->slotService->cleanSlot();
        } catch (\Exception $e) {
            $this->logger->critical('Unable to clean Slot', [
                'component' => Constant::MQ_COMPONENT_NAME,
                'slot'      => $this->slotService->getSlotName(),
                'error'     => $e->getMessage()
            ]);
        }
    }
}
