<?php

namespace App\Service;

use Psr\Log\InvalidArgumentException;

class FilterParser
{
    public function parse(string $filters): array
    {
        if (empty($filters)) {
            return [];
        }

        $tabFilters = explode('&', $filters);

        $results = [];

        foreach ($tabFilters as $filter) {

            $operator = null;
            foreach (['>=', '<=', '<', '>', '='] as $op) {
                if (false !== strpos($filter, $op)) {
                    $operator = $op;
                    break;
                }
            }

            if (null === $operator) {
                throw new InvalidArgumentException(sprintf('Bad filter: %s', $filter));
            }

            $parts = explode($operator, $filter);

            // looking for date
            $matches = [];
            if (preg_match('#d\((.*)\)#i', $parts[1], $matches)) {
                $results[$parts[0]] = [
                    'operator' => $operator,
                    'value' => new \DateTime($matches[1])
                ];
            } elseif ($parts[1] === 'true') {
                $results[$parts[0]] = [
                    'operator' => '=',
                    'value' => true
                ];
            } elseif ($parts[1] === 'false') {
                $results[$parts[0]] = [
                    'operator' => '=',
                    'value' => true
                ];
            } else {
                $results[$parts[0]] = [
                    'operator' => $operator,
                    'value' => $parts[1]
                ];
            }
        }

        return $results;
    }

    public function acceptedForDelivery(\stdClass $body, array $filters): bool
    {
        if (empty($filters)) {
            return true;
        }

        if ($body->type == 'delete') {
            return true;
        }

        $new = $body->new;

        foreach ($filters as $name => $filter) {
            if (!isset($new->{$name})) {
                continue;
            }

            $walValue = $new->{$name};

            // dates
            if ($filter['value'] instanceof \DateTime) {
                $walValue = new \DateTime($new->{$name});
            }

            switch ($filter['operator']) {
                case '=':
                    if ($filter['value'] != $walValue) {
                        return false;
                    }
                    break;
                case '<=':
                    if ($walValue > $filter['value']) {
                        return false;
                    }
                    break;
                case '>=':
                    if ($walValue < $filter['value']) {
                        return false;
                    }
                    break;
                case '<':
                    if ($walValue >= $filter['value']) {
                        return false;
                    }
                    break;
                case '>':
                    if ($walValue <= $filter['value']) {
                        return false;
                    }
                    break;
            }

            return true;
        }

        return true;
    }
}
