<?php

namespace Orms\Exception;

/**
 * Description of QueryException
 *
 * @author xavier
 */

use Orms\Exception\Exception;

class QueryException extends Exception
{
    /**
     * Decimal Error Code
     */
    const ERROR_SUCCESSFUL_COMPLETION = 0;
    const ERROR_WARNING = 1;
    const ERROR_NO_DATA = 2;
    const ERROR_DYNAMIC_SQL_ERROR = 7;
    const ERROR_CONNECTION_EXCEPTION = 8;
    const ERROR_FEATURE_NOT_SUPPORTED = 10;
    const ERROR_CARDINALITY_VIOLATION = 33;
    const ERROR_DATA_EXCEPTION = 34;
    const ERROR_INTEGRITY_CONSTRAINT = 35;
    const ERROR_INVALID_CURSOR_STATE = 36;
    const ERROR_INVALID_TRANSACTION_STATE = 37;
    const ERROR_INVALID_SQL_STATEMENT_NAME = 38;
    const ERROR_TRIGGERED_DATA_CHANGE_VIOLATION = 39;
    const ERROR_INVALID_AUTHORIZATION = 40;
    const ERROR_SYNTAX_ERROR_DIRECT = 42;
    const ERROR_DEPENDENT_PRIVILEG = 43;
    const ERROR_INVALID_CHARACTER_SET_NAME = 44;
    const ERROR_INVALID_TRANSACTION_TERMINATION = 45;
    const ERROR_INVALID_CONNECTION_NAME = 46;
    const ERROR_INVALID_SQL_DESCRIPTOR_NAME = 51;
    const ERROR_INVALID_CURSOR_NAME = 52;
    const ERROR_INVALID_CONDITION_NUMBER = 53;
    const ERROR_SYNTAX_ERROR_IN_DYNAMIC = 55;
    const ERROR_AMBIGUOUS_CURSOR_NAME = 60;
    const ERROR_INVALID_SCHEMA_NAME = 63;
    const ERROR_TRANSACTION_ROLLBACK = 64;
    const ERROR_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION = 66;
    const ERROR_WITH_CHECK_OPTION_VIOLATION = 68;

    /**
     * Error info from PDO
     * @var array
     */
    protected $errorInfo;

    /**
     * Error codes (Hexa code => Error)
     * @var array
     */
    protected $error = array(
        '00' => 'Successful completion',
        '01' => 'Warning',
        '02' => 'No data',
        '07' => 'Dynamic SQL error',
        '08' => 'Connection Exception',
        '0A' => 'Feature not supported',
        '21' => 'Cardinality violation',
        '22' => 'Data exception',
        '23' => 'Integrity constraint violation',
        '24' => 'Invalid cursor state',
        '25' => 'Invalid transaction state',
        '26' => 'Invalid SQL statement name',
        '27' => 'Triggered data change violation',
        '28' => 'Invalid authorization specification',
        '2A' => 'Syntax error or access rule violation in direct SQL statement',
        '2B' => 'Dependent privilege descriptors still exist',
        '2C' => 'Invalid character set name',
        '2D' => 'Invalid transaction termination',
        '2E' => 'Invalid connection name',
        '33' => 'Invalid SQL descriptor name',
        '34' => 'Invalid cursor name',
        '35' => 'Invalid condition number',
        '37' => 'Syntax error or access rule violation in dynamic SQL statement',
        '3C' => 'Ambiguous cursor name',
        '3F' => 'Invalid schema name',
        '40' => 'Transaction rollback',
        '42' => 'Syntax error or access rule violation',
        '44' => 'With check option violation'
    );

    /**
     * Build the exception with error code from PDO Handler
     * Ca be a PDO or PDOStatement
     * @param mixed $pdoObject
     */
    public function __construct($pdoObject)
    {
        $code = substr($pdoObject->errorCode(), 0, 2);
        $message = (isset($this->error[$code])) ? $this->error[$code] : 'Error';
        $errorCode = (isset($this->error[$code])) ? hexdec($code) : 0;

        $this->errorInfo = $pdoObject->errorInfo();

        parent::__construct(
            $message . ': ' . $this->errorInfo[2],
            $errorCode
        );
    }

    /**
     * Return errof detail from PDO
     * @return string
     */
    public function getErrorInfo()
    {
        return $this->errorInfo[2];
    }
}

