<?php

namespace Orms\Connection;

use Orms\Connection\OrmsPDO;

class Postgresql extends OrmsPDO
{
    /**
     * Open a new Postgres OrmsPDO connection
     * @param array $options
     * @return \PDO
     * @throws \Exception
     */
    public function __construct($options = array())
    {
        if (!isset($options['dsn']))
        {
            throw new \Exception('DSN option must be set for class '.__CLASS__);
        }
        
        $driverOptions = 
            isset($options['driver_options']) 
            ? 
            $options['driver_options'] 
            : 
            array();
        
        return parent::__construct(
                $options['dsn'],
                null,
                null,
                $this->buildDriverOptions($driverOptions)
            );
    }
}