<?php

namespace Orms\Connection;

/**
 * Description of OrmsPDO
 *
 * @author Xavier HAUSHERR <xavier.hausherr@ebuzzing.com>
 */
abstract class OrmsPDO extends \PDO
{
    /**
     * Pings the current connection
     *
     * @return boolean
     */
    public function ping()
    {
    	try
    	{
    		return (false !== $this->query('SELECT 1;'));
    	}
    	catch(\PDOException $e)
    	{
    		return false;
    	}
    }
    
    /**
     * Build PDO drivers options
     * @param array $options
     * @return array
     */
    protected function buildDriverOptions($options = array())
    {
        $driverOptions = array();
        
        // Emulate PREPARE by PDO
        if(isset($options['ATTR_EMULATE_PREPARES']))
        {
            $driverOptions[\PDO::ATTR_EMULATE_PREPARES] = (bool)$options['ATTR_EMULATE_PREPARES'];
        }

        return $driverOptions;
    }
}
