<?php

namespace Orms\Type;

use Orms\Type\Exception;

/**
 * Class for integer typing
 */

class Integer extends Type implements TypeInterface
{
    /**
     * sets the value of the object after checking
     *
     * @param mixed $value
     *
     * @return object
     */

    public function setValue($value)
    {
        if (is_null($value)) {
            $this->_value = null;
        } elseif (false === $this->isValid($value)) {
            throw new Exception(
                'Can\'t set a ' . get_called_class() . ' object with the ' .
                'value [' . print_r($value, true) . ']'
            );
        } else {
            $this->_value = intval($value);
        }
    }

    /**
     * Checks if the value provided is valid
     *
     * @param mixed $value
     *
     * @returns boolean
     */

    public function isValid($value)
    {
        return
                (
                        is_int($value) ||
                        (
                                is_numeric($value)
                                &&
                                ($value == intval($value))
                        )
                );
    }

    /**
     * Returns a string version of the object
     *
     * @return string
     */

    public function __toString()
    {
        return strval($this->_value);
    }
}
