<?php

namespace Orms\Test;

use Orms\Type\Xml;

class XmlTest extends \PHPUnit_Framework_TestCase
{
    public function testConstruct1()
    {
        $this->setExpectedException(
            'Orms\Type\Exception',
            'Can\'t create a Orms\Type\Xml object with a null value.'
        );

        $x = new Xml();
    }

    public function testConstruct2()
    {
        $this->setExpectedException(
            'Orms\Type\Exception',
            'Can\'t set a Orms\Type\Xml object with the value [Coin]');

        $x = new Xml('Coin');
    }

    public function testConstruct3()
    {
        $this->setExpectedException(
            'Orms\Type\Exception',
            'Can\'t set a Orms\Type\Xml object with the value [12.5]');

        $x = new Xml(12.5);
    }

    public function testConstruct4()
    {
        $this->setExpectedException(
            'Orms\Type\Exception',
            'Can\'t set a Orms\Type\Xml object with the value [12]');

        $x = new Xml(12);
    }

    public function testConstruct5()
    {
        $this->setExpectedException(
            'Orms\Type\Exception',
            'Can\'t set a Orms\Type\Xml object with the value [Array
(
    [0] => 12
)
]'
        );

        $x = new Xml([12]);
    }

    public function testConstruct6()
    {
        $this->setExpectedException(
            'Orms\Type\Exception',
            'Can\'t set a Orms\Type\Xml object with the value [<glou]'
        );

        $x = new Xml('<glou');
    }

    public function testConstruct7()
    {
        $this->setExpectedException(
            'Orms\Type\Exception',
            'Can\'t set a Orms\Type\Xml object with the value [glou>]'
        );

        $x = new Xml('glou>');
    }

    public function testConstruct8()
    {
        $x = new Xml('<data />');

        $this->assertEquals(
            new \Orms\Tools\SimpleXMLElementExtended('<data />'),
            $x->getValue()
        );
    }

    public function testGetValue()
    {
        $x = new Xml('<data><glou>1</glou><coin>2</coin></data>');

        $this->assertInstanceOf('\Orms\Type\Xml', $x);

        $this->assertEquals('1', strval($x->getValue()->glou));
        $this->assertEquals('2', strval($x->getValue()->coin));

        $x->getValue()->pan = 3;

        $this->assertEquals(
            '<?xml version="1.0"?>' . "\n" .
                '<data><glou>1</glou><coin>2</coin><pan>3</pan></data>' . "\n",
            $x->__toString()
        );

        $this->assertEquals(
            [
                'glou' => ['_value' => 1],
                'coin' => ['_value' => 2],
                'pan'  => ['_value' => 3]
            ],
            $x->getValue()->toArray()
        );
    }
}
