<?php

namespace Orms\Test\Mock;

use Orms\DataProvider\GenericDataProvider;

class ConcreteDataProvider extends GenericDataProvider
{
    public function setup($options)
    {
    }

    public function insert(
        array $definition,
        array $values
    ) {
        return
            [
                'col1'      => 43,
                'col2'      => 'col2 42',
                'col3'      => '"col3"=>"42"',
                'col4'      => '<data><col4>42</col4></data>',
                'col5'      => '2007-01-01 02:02:02',
                'col6'      => '{col6,42}',
                'col7'      => '1111000011110000',
                'col8'      => 42
            ];
    }

    public function update(
            array $definition,
            array $values
    ) {
        return
            [
                'col1'      => 44,
                'col2'      => 'col2 42',
                'col3'      => '"col3"=>"42"',
                'col4'      => '<data><col4>42</col4></data>',
                'col5'      => '2007-01-01 02:02:02',
                'col6'      => '{col6,42}',
                'col7'      => '1111000011110000',
                'col8'      => 42
            ];
    }

    public function delete(
        array $definition,
        array $values
    ) {
        return true;
    }

    public static function getComposer($params)
    {
        // Primary key col1 = 42;

        if (
                ($params == ['col1' => 42])
                ||
                ($params == ['col1' => 42, 'limit' => 2])
                ||
                ($params == ['col1' => 42, 'countOnly' => false])
        ) {
            return
                new \ArrayIterator(
                    [
                        [
                            'col1'      => 42,
                            'col2'      => 'col2 42',
                            'col3'      => '"col3"=>"42"',
                            'col4'      => '<data><col4>42</col4></data>',
                            'col5'      => '2007-01-01 02:02:02',
                            'col6'      => '{col6,42}',
                            'col7'      => '1111000011110000',
                            'col8'      => 42
                        ]
                    ]
                );
        }


        return new \ArrayIterator();
    }
}
