<?php

namespace Orms\DataProvider;

use Orms\DataProvider\GenericDataProvider;

abstract class RiakDataProvider extends GenericDataProvider
{

    /**
     * In this case the service class is a database connexion to a postgresql
     * server. This class is still abstract, so connectino params must be set
     * in child class
     *
     * However, the service parameter an array defining host and port parameters
     */

    protected $_serviceClass = 'Orms\Service\RiakService';

    /**
     * @var string $_serviceParams;
     */

    protected $_serviceParams;

    /**
     * shema & table name
     */

    protected $_bucket;

    protected function _initService()
    {
        if (is_null($this->_service))
        {
            $this->_service =
                    new $this->_serviceClass(
                        $this->_serviceParams['host'],
                        $this->_serviceParams['port']
                    );

            $this->_service->bucket($this->_bucket);
        }
    }

    /**
     * Inserts some data.
     *
     * @param Array $values values of the row to be inserted
     *
     * @return mixed - returns Array of $values after the insertion or throw an
     * exception
     *
     * @author Yannick Le Guédart
     */

    public function insert(Array $values)
    {
        $object =
                new \Orms\Service\RiakObject(
                    $this->_service,
                    $this->_service->bucket($this->_bucket),
                    $values['key']
                );

        // Execution

        $object->setData($values);
        $object->setContentType('text/plain');

        $object->store();

        return $object->getData();
    }

    /**
     * Update a row.
     *
     * @param Array $values value of the row to be inserted
     *
     * @return mixed - returns Array of $values after the insertion or throw an
     * exception
     *
     * @author Yannick Le Guédart
     */

    public function update(Array $values)
    {
        // Génération de la clef

        $object =
                new \Orms\Service\RiakObject(
                    $this->_service,
                    $this->_service->bucket($this->_bucket),
                    $values['key']
                );

        // Execution

        $object->setData($values);
        $object->setContentType('text/plain');

        $object->store();

        return $object->getData();
    }

    /**
     * Delete a row.
     *
     * @return boolean
     *
     * @author Yannick Le Guédart
     */

    public function delete(Array $values)
    {
        $key = ($keyComplete === true) ? $key : null;

        $object =
                new \Orms\Service\RiakObject(
                    $this->_service,
                    $this->_service->bucket($this->_bucket),
                    $values['key']
                );

        // Execution

        return $object->delete();
    }

    public function get(Array $params)
    {
        if (array_keys($params) === array('key'))
        {
            return
                    new \ArrayObject(
                        array(
                             $this
                             ->_service
                                     ->bucket($this->_bucket)
                                     ->get($params['key'])
                             ->data
                        )
                    );
        }
        else
        {
            $params['_service'] = $this->_service;
            $params['_bucket'] = $this->_bucket;

            return parent::get($params);
        }
    }


    /**
     * get composer
     */

    static public $_getBaseParams =
    array
    (
        '_service' => null,
        '_bucket' => null
    );

    static public $_getFilterParams =
    array
    (
        'id_blog' => null,
        'id_content' => null,
    );

    static protected function getComposer($params)
    {
        if (!is_array($params))
        {
            throw new Exception(
                '$params is not an array'
            );
        }

        // Tableaux de paramètres par défaut.

        $baseDefault = array();
        $filterDefault = array();

        // Tableaux de paramètres réels.

        $filterParams = array();

        $classLoop = get_class();


        while ($classLoop)
        {
            foreach ($classLoop::$_getBaseParams as $k => $v)
            {
                if (!isset($baseDefault[$k]))
                {
                    $baseDefault[$k] = $v;
                }
            }

            foreach ($classLoop::$_getFilterParams as $k => $v)
            {
                if (!isset($filterDefault[$k]))
                {
                    $filterDefault[$k] = $classLoop;

                    if (!is_null($v))
                    {
                        $filterParams[$k] = $v;
                    }
                }
            }

            if ($classLoop === 'GenericDataProvider')
            {
                break;
            }

            $classLoop = get_parent_class($classLoop);
        }

        /* ---------------------------------------------------------------------
           * Génération des tableaux de paramètres réels
           * ---------------------------------------------------------------------
           */

        $baseParams = $baseDefault;

        foreach ($params as $k => $v)
        {
            if (array_key_exists($k, $baseParams))
            {
                $baseParams[$k] = $v;
            }
            elseif (array_key_exists($k, $filterDefault))
            {
                $filterParams[$k] = $v;
            }
            else
            {
                throw new \Orms\Exception\Exception(
                    'Invalid query parameter [' . $k . ']'
                );
            }
        }

        /* ---------------------------------------------------------------------
           * Génération du tableau de bouts de requetes SQL utilisées poru les
           * filtres.
           * ---------------------------------------------------------------------
           */

        $filterSQLArray = array();

        foreach ($filterParams as $k => $v)
        {
            if (!is_null($v))
            {
                $oneFilter =
                        call_user_func_array
                        (
                            array
                            (
                            $filterDefault[$k],
                            '_getFilterSQL'
                            ),
                            array($k, $v)
                        );

                if (!is_null($oneFilter) and ($oneFilter !== ''))
                {
                    $filterSQLArray[] = $oneFilter;
                }
            }
        }

        /* ---------------------------------------------------------------------
           * Exécution de la requête SQL.
           */

        $riak = $baseParams['_service'];

        $returnArray = array();

        $bucket = $riak->add($baseParams['_bucket']);

        $firstFilter = true;

        foreach ($filterSQLArray as $f)
        {
            if ($firstFilter === true)
            {
                $bucket->key_filter($f[0], $f[1]);

                $firstFilter = false;
            }
            else
            {
                $bucket->key_filter_and($f[0], $f[1]);
            }
        }

        $results =
                $bucket
                        ->map("function (v) { return [v]}")
                        ->reduce("Riak.reduceSort")
                        ->run();

        foreach ($results as $r)
        {
            if (!is_object($r))
            {
                throw new \Orms\Exception\Exception($r);
            }

            $returnArray[] =
                    array_merge(
                        get_object_vars(json_decode($r->values[0]->data)),
                        array('key' => $r->key)
                    );
        }

        return new \ArrayObject($returnArray);

    }

    static public function _getFilterSQL($k, $v)
    {
        $filterSQL = null;

        switch ($k)
        {
            case 'id_blog':
                $filterSQL =
                        array(
                            array('tokenize', '.', 3),
                            array('eq', strval($v))
                        );
                break;
            case 'id_content':
                $filterSQL =
                        array(
                            array('tokenize', '.', 4),
                            array('eq', strval($v))
                        );
                break;
        }

        return $filterSQL;
    }
}
