<?php

namespace Orms\Test;

require_once(__DIR__ . '/../../Orms/Type/Type.php');
require_once(__DIR__ . '/../../Orms/Type/Exception.php');
require_once(__DIR__ . '/../../Orms/Type/String.php');

use Orms\Type\String;

class StringTest extends \PHPUnit_Framework_TestCase
{
	public function testConstruct1()
	{
		$s = new String();

        $this->assertTrue(is_null($s->getValue()));
    }

	public function testConstruct2()
	{
		$s = new String('Coin');

		$this->assertSame('Coin', $s->getValue());
		$this->assertSame('Coin', $s->__toString());
	}

	public function testConstruct3()
	{
		$s = new String(12.5);

		$this->assertSame('12.5', $s->getValue());
		$this->assertSame('12.5', $s->__toString());
	}

	public function testConstruct4()
	{
		$s = new String(12);

		$this->assertSame('12', $s->getValue());
		$this->assertSame('12', $s->__toString());
	}

	public function testConstruct6()
	{
		$this->setExpectedException(
			'Orms\Type\Exception',
			'Can\'t set a Orms\Type\String object with the value [Array
(
    [0] => 12
)
]'
		);

		$s = new String(array(12));

        $s = new String(new StdClass());
	}

    public function testConstruct7()
	{
		$this->setExpectedException(
			'Orms\Type\Exception',
			'Can\'t set a Orms\Type\String object with the value [stdClass Object
(
)
]'
		);

        $s = new String(new \StdClass());
	}
}