<?php

namespace Orms\Connection;

/**
 * Handler help managing connection
 *
 * @author xavier
 */

class Handler
{
    /**
     * Connection Handler
     * @var mixed
     */
    protected $handler;

    /**
     * Connection Class
     * @var string
     */
    protected $type;

    /**
     * Connection Options
     * @var array
     */
    protected $options;

    /**
     * Init Handler
     *
     * @param string $type
     * @param array $options
     */
    public function __construct($type, $options = array())
    {
        $this->type = $type;
        $this->options = $options;
    }

    /**
     * Get connection handler
     *
     * @return mixed
     */
    public function getConnection()
    {
        if (is_null($this->handler))
        {
            $class = __NAMESPACE__ . '\\' . $this->type;

            $this->handler = new $class($this->options);
        }

        return $this->handler;
    }

    /**
     * Close connection handler
     */
    public function close()
    {
        unset($this->handler);

        $this->handler = null;
    }

    /**
     * Ping the server to see if connection is open
     * @return boolean
     */
    public function ping()
    {
        if (! is_null($this->handler) && (false !== $this->handler->ping()))
        {
            return true;
        }
        else
        {
            try
            {
                $this->reset();

                return true;
            }
            catch(\Exception $e)
            {
                return false;
            }
        }
    }

    /**
     * Reset connection
     * @return mixed
     */
    public function reset()
    {
        $this->handler = null;

        return $this->getConnection();
    }

    /**
     * Close connection handler
     */
    public function __destruct()
    {
        $this->close();
    }

    public function getType()
    {
        return $this->type;
    }

    public function getOption($name)
    {
        if (isset($this->options[$name]))
        {
            return $this->options[$name];
        }

        return null;
    }
}

