<?php

namespace Orms\Connection;

use Orms\Exception\Exception;

class Mysql extends \PDO
{

    public function __construct($options = array())
    {
        if (!isset($options['dsn']))
        {
            throw new \Exception("Dsn option must be set for class " . __CLASS__);
        }
        
        $option_utf8 = array(parent::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8");
        
        if (isset($options['utf8']) && $options['utf8'] === false)
        {
            $option_utf8 = null;
        }

        $username = isset($options['username']) ? $options['username'] : null;
        $password = isset($options['password']) ? $options['password'] : null;
        $utf8_option = isset($options['utf8']) ? $options['utf8'] : true;
        $connectionOptions = isset($options['options']) ? $options['options']
                : array();
        
        if (is_array($connectionOptions) && $utf8_option === true) 
        {
            $connectionOptions[parent::MYSQL_ATTR_INIT_COMMAND] = 'SET NAMES utf8';
        }

        return parent::__construct($options['dsn'], $username, $password, $connectionOptions);
    }

    /**
     * Pings the current connection
     *
     * @return boolean
     */

    public function ping()
    {
        try
        {
            return (false !== $this->query('SELECT 1;'));
        }
        catch(\PDOException $e)
        {
            return false;
        }
    }    
}

