<?php

require_once(__DIR__ . '/../Orms/Object/DataObjectDefinition.php');
require_once(__DIR__ . '/../Orms/Object/DataObject.php');
require_once(__DIR__ . '/../Orms/Connection/Mysql.php');
require_once(__DIR__ . '/../Orms/DataProvider/GenericDataProvider.php');
require_once(__DIR__ . '/../Orms/Tools/Inflector.php');
require_once(__DIR__ . '/../Orms/Tools/SimpleXMLElementExtended.php');
require_once(__DIR__ . '/../Orms/Type/TypeInterface.php');
require_once(__DIR__ . '/../Orms/Type/Type.php');
require_once(__DIR__ . '/../Orms/Type/Hstore.php');
require_once(__DIR__ . '/../Orms/Type/PgArray.php');
require_once(__DIR__ . '/../Orms/Type/Xml.php');
require_once(__DIR__ . '/../Orms/Exception/Exception.php');
require_once(__DIR__ . '/../Orms/Exception/NoRowsFoundException.php');


use Orms\Object\DataObject;
use Orms\DataProvider\GenericDataProvider;


/* Mock classes for testing DataObject */

class ConcreteDataObjectNoProviderClass extends DataObject
{
}

class ConcreteDataObjectNotSavableClass extends DataObject
{
	static protected $_providerClass = 'ConcreteDataProvider';

	protected $_savable = false;
}

class ConcreteDataProvider extends GenericDataProvider
{
	public function setup($options)
	{
	}

	public function insert(
		Array $definition,
		Array $values
	)
	{
		return
			array(
				'col1'		=> 43,
				'col2'		=> 'col2 42',
				'col3'		=> '"col3"=>"42"',
				'col4'		=> '<data><col4>42</col4></data>',
				'col5'		=> '2007-01-01 02:02:02',
				'col6'		=> '{col6,42}',
				'col7'		=> '1111000011110000',
				'col8'		=> 42
			);
	}

	public function update(
			Array $definition,
			Array $values
	)
	{
		return
			array(
				'col1'		=> 44,
				'col2'		=> 'col2 42',
				'col3'		=> '"col3"=>"42"',
				'col4'		=> '<data><col4>42</col4></data>',
				'col5'		=> '2007-01-01 02:02:02',
				'col6'		=> '{col6,42}',
				'col7'		=> '1111000011110000',
				'col8'		=> 42
			);
	}

	public function delete(
		Array $definition,
		Array $values
	)
	{
		return true;
	}

	static public function getComposer($params)
	{
		// Primary key col1 = 42;

		if (
				($params == array('col1' => 42))
				or
				($params == array('col1' => 42, 'limit' => 2))
				or
				($params == array('col1' => 42, 'countOnly' => false))
		)
		{
			return
				new ArrayObject(
					array(
						array(
							'col1'		=> 42,
							'col2'		=> 'col2 42',
							'col3'		=> '"col3"=>"42"',
							'col4'		=> '<data><col4>42</col4></data>',
							'col5'		=> '2007-01-01 02:02:02',
							'col6'		=> '{col6,42}',
							'col7'		=> '1111000011110000',
							'col8'		=> 42
						)
					)
				);
		}


		return new ArrayObject();
	}
}

class ConcreteConnection
{
}

class ConcreteDataObject extends DataObject
{
	static protected $_pkFields =
		array(
			'col1'
		);

	static protected $_columns =
		array(
			'col1' =>
				array(
					'type' => 'integer'
				),
			'col2' =>
				array(
					'type' => 'string'
				),
			'col3' =>
				array(
					'type'		=> 'hstore',
					'default'	=> ''
				),
			'col4' =>
				array(
					'type' 		=> 'xml',
					'default'	=> '<data />'
				),
			'col5' =>
				array(
					'type' 		=> 'date',
					'default'	=> "now"
				),
			'col5_1' =>
				array(
					'type' 		=> 'datetime',
					'default'	=> "now"
				),
			'col5_2' =>
				array(
					'type' 		=> 'time',
					'default'	=> "now"
				),
			'col6' =>
				array(
					'type' 		=> 'pg_array',
					'default'	=> "{}"
				)
		);

	public function getValues() { return $this->_string_values; }
}
