<?php

namespace Orms\Type;

use Orms\Type\Exception;

abstract class DateType extends Type implements TypeInterface
{
    static protected $_format = null;

    /**
     * sets the value of the object after checking
     *
     * @param mixed $value
     *
     * @return object
     */

    public function setValue($value)
    {
        // suite à un étrange bug de timezones entre php et postgresql,
        // concernant les dates précédent 1911, on essaye de récupérer le truc
        // Postgresql est capable de stocker la timezone avec des secondes, 
        // alors que php non.

        if (
                is_string($value) 
                and
                preg_match('/([\+\-])\d{2}:\d{2}:(\d{2})$/', $value, $m)
        )
        {
            $di   = new \DateInterval('PT' . $m[2] . 'S');
            $sign = $m[1];

            $value = 
                preg_replace(
                    '/([\+\-]\d{2}:\d{2}):\d{2}$/', 
                    '$1', 
                    $value
                );

            $dt = new \DateTime($value);

            if ('-' === $sign)
            {
                $dt->add($di);
            }
            else
            {
                $dt->sub($di);
            }

            $value = $dt->format('c');
        }

        // Cas débilissime des TZ avec des virgules dedans, mais sans secondes

        elseif (
            is_string($value) 
            and
            preg_match('/([\+\-])\d{2}(\.\d+):\d{2}$/', $value, $m)
        )
        {
            $di   = new \DateInterval('PT' . (60 * floatval($m[2])) . 'M');
            $sign = $m[1];

            $value = 
                preg_replace(
                    '/([\+\-]\d{2})\.\d+(:\d{2})$/', 
                    '$1$2', 
                    $value
                );

            $dt = new \DateTime($value);

            if ('-' === $sign)
            {
                $dt->add($di);
            }
            else
            {
                $dt->sub($di);
            }

            $value = $dt->format('c');
        }

        parent::setValue($value);

        $this->_value = new \DateTime($value);
    }

    /**
     * Gets an usable value of the object
     *
     * @return mixed
     */

    public function getValue()
    {
        return $this->_value;
    }

    /**
     * Convert to a valid pg string for arrays
     *
     * @return string
     */

    public function __toString()
    {
        return $this->_value->format(static::$_format);
    }

    /**
     * Checks if the value provided is valid
     *
     * @param mixed $value
     *
     * @returns boolean
     */

    public function isValid($value)
    {
        // $value must be a string

        if (!is_string($value))
        {
            return false;
        }

        return 
            (
                (false !== strtotime($value))
                and
                ! preg_match('/\+\d{2}(\.\d+)?:\d{2}:\d{2}$/', $value)
            );
    }
}
