<?php

namespace Orms\Type;

use Orms\Type\Exception;

/**
 * Class for integer typing
 */

class Boolean extends Type implements TypeInterface
{
    /**
     * sets the value of the object after checking
     *
     * @param mixed $value
     *
     * @return object
     */

    public function setValue($value)
    {
        parent::setValue($value);

        if (is_bool($value))
        {
            $this->_value = $value;
        }
        elseif (is_string($value))
        {
            $this->_value = (($value === 't') or ($value === '1'));
        }
        else
        {
            $this->_value = ($value === 1);
        }
    }

    /**
     * Checks if the value provided is valid
     *
     * @param mixed $value
     *
     * @returns boolean
     */

    public function isValid($value)
    {
        return
                (
                        is_bool($value)
                        or (is_string($value)
                            and in_array($value, array('t', 'f', '1', '0'))
                        )
                        or
                        (
                                is_int($value)
                                and
                                (
                                        ($value === 1) or ($value === 0)
                                )
                        )
                );
    }

    /**
     * Returns a string version of the object
     *
     * @return string
     */

    public function __toString()
    {
        return $this->_value;
    }
}