<?php

/**
 * File ThriftLinkedDataObject
 *
 * @package    Orms
 * @subpackage DataObject
 * @version    1.0
 * @author     Yannick Le Guédart
 */

namespace Orms\Object;

use Orms\Object\DataObject;

/**
 * Class ThriftLinkedDataObject
 *
 * This class defines orms model objects that are somehow linked to a thrift
 * definition. It defines two abstract methods that have to be implemented
 * in order to convert to and be converted from the thrift object
 *
 * @package    Orms
 * @subpackage DataObject
 * @author     Yannick Le Guédart
 */

abstract class ThriftLinkedDataObject extends DataObject
{
    /**
     * Produces a thrift object  from the data object
     *
     * @return object Thrift object associated with the current object
     */

    abstract public function toThriftObject();

    /**
     * Sets the dataobject from a thrift object
     *
     * @param object $to The thrift object
     */

    abstract public function setFromThriftObject($to);
}
