<?php

namespace Orms\Type;

use Orms\Tools\SimpleXMLElementExtended;

class Xml extends Type implements TypeInterface
{
    /**
     * sets the value of the object after checking
     *
     * @param mixed $value
     *
     * @return object
     */

    public function setValue($value)
    {
        parent::setValue($value);

        $this->_decode($value);
    }

    /**
     * Gets an usable value of the object
     *
     * @return mixed
     */

    public function getValue()
    {
        return $this->_value;
    }

    /**
     * Convert to a valid pg string for arrays
     *
     * @return string
     */

    public function __toString()
    {
        return $this->_value->asXML();
    }

    /**
     * Checks if the value provided is valid
     *
     * @param mixed $value
     *
     * @returns boolean
     */

    public function isValid($value)
    {
        // $value must be a string

        if (!is_string($value)) {
            return false;
        }

        return (false !== @simplexml_load_string($value));
    }

    /**
     * Parsing method
     *
     * @param string      $value
     *
     * @return void
     */

    protected function _decode($value)
    {
        $this->_value =
            @simplexml_load_string(
                $value,
                'Orms\Tools\SimpleXMLElementExtended'
            );
    }
}
