<?php

namespace Orms\Tests\Type;

use Orms\Type\StringType;

class StringTypeTest extends \PHPUnit_Framework_TestCase
{
    public function testConstruct1()
    {
        $s = new StringType();

        $this->assertTrue(is_null($s->getValue()));
    }

    public function testConstruct2()
    {
        $s = new StringType('Coin');

        $this->assertSame('Coin', $s->getValue());
        $this->assertSame('Coin', $s->__toString());
    }

    public function testConstruct3()
    {
        $s = new StringType(12.5);

        $this->assertSame('12.5', $s->getValue());
        $this->assertSame('12.5', $s->__toString());
    }

    public function testConstruct4()
    {
        $s = new StringType(12);

        $this->assertSame('12', $s->getValue());
        $this->assertSame('12', $s->__toString());
    }

    public function testConstruct6()
    {
        $this->setExpectedException(
            'Orms\Type\Exception',
            'Can\'t set a Orms\Type\StringType object with the value [Array
(
    [0] => 12
)
]'
        );

        $s = new StringType([12]);

        $s = new StringType(new StdClass());
    }

    public function testConstruct7()
    {
        $this->setExpectedException(
            'Orms\Type\Exception',
            'Can\'t set a Orms\Type\StringType object with the value [stdClass Object
(
)
]'
        );

        $s = new StringType(new \StdClass());
    }
}
