<?php

namespace Orms\Tests\Type;

use Orms\Type\Boolean;

class BooleanTest extends \PHPUnit_Framework_TestCase
{
    public function testConstruct1()
    {
        $this->setExpectedException(
            'Orms\Type\Exception',
            'Can\'t create a Orms\Type\Boolean object with a null value.'
        );

        $b = new Boolean();
    }

    public function testConstruct2()
    {
        $b = new Boolean(true);

        $this->assertTrue($b->getValue());
        $this->assertTrue($b->__toString());

        $b = new Boolean(false);

        $this->assertFalse($b->getValue());
        $this->assertFalse($b->__toString());

        $b = new Boolean(1);

        $this->assertTrue($b->getValue());
        $this->assertTrue($b->__toString());

        $b = new Boolean(0);

        $this->assertFalse($b->getValue());
        $this->assertFalse($b->__toString());

        $b = new Boolean('1');

        $this->assertTrue($b->getValue());
        $this->assertTrue($b->__toString());

        $b = new Boolean('0');

        $this->assertFalse($b->getValue());
        $this->assertFalse($b->__toString());

        $b = new Boolean('t');

        $this->assertTrue($b->getValue());
        $this->assertTrue($b->__toString());

        $b = new Boolean('f');

        $this->assertFalse($b->getValue());
        $this->assertFalse($b->__toString());
    }

    public function testConstruct4()
    {
        $this->setExpectedException(
            'Orms\Type\Exception',
            'Can\'t set a Orms\Type\Boolean object with the value [12.5]'
        );

        $b = new Boolean(12.5);
    }

    public function testConstruct5()
    {
        $this->setExpectedException(
            'Orms\Type\Exception',
            'Can\'t set a Orms\Type\Boolean object with the value [Array
(
    [0] => 12
)
]'
        );

        $b = new Boolean([12]);
    }
}
