<?php

namespace Orms\Tests\Mock;

use Orms\Object\DataObject;

class ConcreteDataObject extends DataObject
{
    protected static $_pkFields =
        [
            'col1'
        ];

    protected static $_columns =
        [
            'col1' =>
                [
                    'type' => 'integer'
                ],
            'col2' =>
                [
                    'type' => 'string'
                ],
            'col3' =>
                [
                    'type'      => 'hstore',
                    'default'   => ''
                ],
            'col4' =>
                [
                    'type'      => 'xml',
                    'default'   => '<data />'
                ],
            'col5' =>
                [
                    'type'      => 'date',
                    'default'   => "now"
                ],
            'col5_1' =>
                [
                    'type'      => 'date_time',
                    'default'   => "now"
                ],
            'col5_2' =>
                [
                    'type'      => 'time',
                    'default'   => "now"
                ],
            'col6' =>
                [
                    'type'      => 'pg_array',
                    'default'   => "{}"
                ]
        ];

    public function getValues()
    {
        return $this->_string_values;
    }

    /**
     * find method
     */

    public static function find(
        $provider,
        array $params = [],
        array $links = null)
    {
        $result = new \ArrayIterator();

        $result->append(new ConcreteDataObject(
                $provider,
                $params
            ));

        return $result;
    }
}
