<?php

namespace Orms\Test;

require_once(__DIR__ . '/../../Orms/Type/Type.php');
require_once(__DIR__ . '/../../Orms/Type/Exception.php');
require_once(__DIR__ . '/../../Orms/Type/Integer.php');

use Orms\Type\Integer;

class IntegerTest extends \PHPUnit_Framework_TestCase
{
	public function testConstruct1()
	{
		$i = new Integer();

        $this->assertTrue(is_null($i->getValue()));
	}

	public function testConstruct2()
	{
		$i = new Integer(12);

		$this->assertSame(12, $i->getValue());
		$this->assertSame('12', $i->__toString());
	}

	public function testConstruct3()
	{
		$i = new Integer('12');

		$this->assertSame(12, $i->getValue());
		$this->assertSame('12', $i->__toString());
	}

	public function testConstruct4()
	{
		$this->setExpectedException(
			'Orms\Type\Exception',
			'Can\'t set a Orms\Type\Integer object with the value [12.5]'
		);

		$i = new Integer(12.5);
	}

	public function testConstruct5()
	{
		$this->setExpectedException(
			'Orms\Type\Exception',
			'Can\'t set a Orms\Type\Integer object with the value [Array
(
    [0] => 12
)
]'
		);

		$i = new Integer(array(12));
	}
}