<?php

namespace Orms\Tests\Type;

use Orms\Type\DateTime;

class DateTimeTest extends \PHPUnit_Framework_TestCase
{
    public function testConstruct1()
    {
        $this->setExpectedException(
            'Orms\Type\Exception',
            'Can\'t create a Orms\Type\DateTime object with a null value.'
        );

        $d = new DateTime();
    }

    public function testConstruct2()
    {
        $this->setExpectedException(
            'Orms\Type\Exception',
            'Can\'t set a Orms\Type\DateTime object with the value [Coin]');

        $d = new DateTime('Coin');
    }

    public function testConstruct3()
    {
        $this->setExpectedException(
            'Orms\Type\Exception',
            'Can\'t set a Orms\Type\DateTime object with the value [12.5]');

        $d = new DateTime(12.5);
    }

    public function testConstruct4()
    {
        $this->setExpectedException(
            'Orms\Type\Exception',
            'Can\'t set a Orms\Type\DateTime object with the value [12]');

        $d = new DateTime(12);
    }

    public function testConstruct5()
    {
        $this->setExpectedException(
            'Orms\Type\Exception',
            'Can\'t set a Orms\Type\DateTime object with the value [Array
(
    [0] => 12
)
]'
        );

        $d = new DateTime([12]);
    }

    public function testConstruct8()
    {
        $d = new DateTime('now');

        $this->assertEquals(date('c'), $d->__toString());
    }

    public function testConstruct9()
    {
        $d = new DateTime('2000-01-01');

        $this->assertEquals(date('c', strtotime('2000-01-01')), $d->__toString());
    }

    // Timezones à la con

    public function testConstruct10()
    {
        $d = new DateTime('2012-06-05T16:51:10+05.5:00');

        $this->assertEquals(
            '2012-06-05T16:21:10+05:00',
            $d->__toString()
        );

        $d = new DateTime('2012-06-05T16:51:10-05.5:00');

        $this->assertEquals(
            '2012-06-05T17:21:10-05:00',
            $d->__toString()
        );
    }
}
