<?php

namespace Orms\Statement;

use Orms\Statement\Statement;

/**
 * MysqlStatement
 *
 * Représente une requête SolR préparée, le jeu de résultats associé.
 *
 * @author Xavier HAUSHERR <xavier.hausherr@ebuzzing.com>
 */
class SolrStatement extends Statement
{
    /**
     * Init Statement with SolrObject
     * @param \SolrObject $resource
     */
    public function __construct(\SolrObject $resource)
    {
        parent::__construct($resource);
    }

    /**
     * {@inheritDoc}
     */
    public function __destruct()
    {
    }

    /**
     * Not implemented
     * @param array $params
     * @throws \LogicException
     */
    public function execute($params)
    {
        throw new \LogicException('Cannot excute request on SolrStatement');
    }

    /**
     * {@inheritDoc}
     */
    public function fetch($style = self::FETCH_ASSOC, $index = null)
    {
        $result = $this->resource->docs[$index];

        switch ($style) {
            case self::FETCH_OBJ:
                return $result;

            case self::FETCH_NUM:
                return array_values((array)$result);

            case self::FETCH_ASSOC:
            default:
                return (array)$result;
       }
    }

    /**
     * {@inheritDoc}
     */
    public function rowCount()
    {
        // Docs can be false...
        if (false === $this->resource->docs) {
            return 0;
        } else {
            return count($this->resource->docs);
        }
    }
}
