<?php

namespace Orms\Statement;

use Orms\Statement\Statement;
use Orms\Exception\SqlExceptionInterface;

/**
 * Weird implementation because of : http://stackoverflow.com/questions/30094744/pdo-dblib-mssql-more-statements-error
 */
class MssqlStatement extends Statement implements SqlExceptionInterface
{
    /**
     * @var \PDOStatement
     */
    private $statement;

    /**
     * @var \PDO
     */
    private $connection;

    /**
     * @var array
     */
    private $fetchedData;

    /**
     * @param \PDOStatement $statement
     */
    public function __construct(\PDO $connection, \PDOStatement $statement)
    {
        $this->connection  = $connection;
        $this->statement   = $statement;
        $this->fetchedData = $this->statement->fetchAll(self::FETCH_ASSOC);
    }

    /**
     * {@inheritDoc}
     */
    public function rowCount()
    {
        return count($this->fetchedData);
    }

    /**
     * {@inheritDoc}
     */
    public function current()
    {
        return $this->fetchedData[$this->key];
    }

    /**
     * @return {@inheritDoc}
     */
    public function valid()
    {
        return isset($this->fetchedData[$this->key]);
    }

    /**
     * {@inheritDoc}
     */
    public function fetch($style = self::FETCH_ASSOC, $index = null)
    {
        $index = $index !== null ? $index : $this->key;

        if ($style == self::FETCH_NUM) {
            return array_values($this->fetchedData[$index]);
        }

        return $this->fetchedData[$index];
    }

    /**
     * {@inheritDoc}
     */
    public function execute($params)
    {
        throw new \RuntimeException('Execute is disabled. See classdoc.');
    }

    /**
     * {@inheritDoc}
     */
    public function errorCode()
    {
        return $this->statement->errorCode();
    }

    /**
     * {@inheritDoc}
     */
    public function errorInfo()
    {
        return $this->statement->errorInfo();
    }

    /**
     * {@inheritDoc}
     */
    public function __destruct()
    {
        $this->statement = null;

        return true;
    }
}
