<?php

namespace Orms\Proxy\Dumper;

class UncachedDirectMethodDumper extends AbstractMethodDumper implements MethodDumperInterface
{
    const METHOD_TEMPLATE = <<<EOF
    %visibility% function %method% (%arguments%) {
        return \$this->registry->get('%service%')->%service_method%(%arguments_short%);
    }
EOF;

    /**
     * @var string
     */
    private $serviceName;

    /**
     * @var string
     */
    private $serviceMethod;

    /**
     * @param string $serviceName
     * @param string $serviceMethod
     */
    public function __construct($serviceName, $serviceMethod)
    {
        $this->serviceName   = $serviceName;
        $this->serviceMethod = $serviceMethod;
    }

    /**
     * {@inheritsDoc}
     */
    public function dump(\ReflectionMethod $method, $configName)
    {
        $argumentsShort = $this->dumpParameters($method->getParameters(), false);

        return str_replace(
            [
                '%visibility%',
                '%method%',
                '%arguments%',
                '%arguments_short%',
                '%service%',
                '%service_method%',
            ],
            [
                $this->getVisibility($method),
                $method->name,
                $this->dumpParameters($method->getParameters()),
                '$this' . (!empty($argumentsShort) ? ', ' . $argumentsShort : ''),
                $this->serviceName,
                $this->serviceMethod
            ],
            self::METHOD_TEMPLATE
        );
    }
}
