<?php

namespace Orms\Type;

use Orms\Type\Exception;

/**
 * Abstract class pour les définition de types d'objets
 */

abstract class Type
{
    protected $_value = null;

    public function __construct($value = null)
    {
        $this->setValue($value);
    }

    /**
     * sets the value of the object after checking
     *
     * @param mixed $value
     *
     * @return object
     */

    public function setValue($value)
    {
        if (is_null($value)) {
            throw new Exception(
                'Can\'t create a ' . static::class . ' object with a ' .
                'null value.'
            );
        }

        if (false === $this->isValid($value)) {
            throw new Exception(
                'Can\'t set a ' . static::class . ' object with the ' .
                'value [' . print_r($value, true) . ']'
            );
        }
    }

    /**
     * Gets an usable value of the object
     *
     * @return mixed
     */

    public function getValue()
    {
        return $this->_value;
    }
}
