<?php

namespace Orms\Tests\Type;

use Orms\Type\Integer;
use PHPUnit\Framework\TestCase;

class IntegerTest extends TestCase
{
    public function testConstruct1()
    {
        $i = new Integer();

        $this->assertTrue(is_null($i->getValue()));
    }

    public function testConstruct2()
    {
        $i = new Integer(12);

        $this->assertSame(12, $i->getValue());
        $this->assertSame('12', $i->__toString());
    }

    public function testConstruct3()
    {
        $i = new Integer('12');

        $this->assertSame(12, $i->getValue());
        $this->assertSame('12', $i->__toString());
    }

    public function testConstruct4()
    {
        $this->setExpectedException(
            'Orms\Type\Exception',
            'Can\'t set a Orms\Type\Integer object with the value [12.5]'
        );

        $i = new Integer(12.5);
    }

    public function testConstruct5()
    {
        $this->setExpectedException(
            'Orms\Type\Exception',
            'Can\'t set a Orms\Type\Integer object with the value [Array
(
    [0] => 12
)
]'
        );

        $i = new Integer([12]);
    }
}
