<?php

namespace Orms\Test;

use Orms\Type\Point;

class PointTest extends \PHPUnit_Framework_TestCase
{
	public function testConstruct1()
	{
		$this->setExpectedException(
			'Orms\Type\Exception',
			'Can\'t create a Orms\Type\Point object with a null value.'
		);
	
		$p = new Point();
	}

	public function testConstruct2()
	{
		$this->setExpectedException(
			'Orms\Type\Exception',
			'Can\'t set a Orms\Type\Point object with the value [Coin]');
		
		$p = new Point('Coin');
	}

	public function testConstruct3()
	{
		$this->setExpectedException(
			'Orms\Type\Exception',
			'Can\'t set a Orms\Type\Point object with the value [12.5]');
		
		$p = new Point(12.5);
	}

	public function testConstruct4()
	{

		$this->setExpectedException(
			'Orms\Type\Exception',
			'Can\'t set a Orms\Type\Point object with the value [12]');
		
		$p = new Point(12);
	}
	
	public function testConstruct5()
	{
		$p = new Point(array(12,36));
		
		$this->assertEquals(12, $p->getValue()->x);
		$this->assertEquals(36, $p->getValue()->y);

		$p = new Point(array(12.0,36.50));
		
		$this->assertEquals(12.0, $p->getValue()->x);
		$this->assertEquals(36.5, $p->getValue()->y);

		$p = new Point(array(-12,36));
		
		$this->assertEquals(-12, $p->getValue()->x);
		$this->assertEquals(36, $p->getValue()->y);

		$p = new Point(array(12.0,-36.50));
		
		$this->assertEquals(12.0, $p->getValue()->x);
		$this->assertEquals(-36.5, $p->getValue()->y);
		
	}

	public function testConstruct6()
	{
		$p = new Point('12,36');
		
		$this->assertEquals(12, $p->getValue()->x);
		$this->assertEquals(36, $p->getValue()->y);

		$p = new Point('12.0,36.50');
		
		$this->assertEquals(12.0, $p->getValue()->x);
		$this->assertEquals(36.5, $p->getValue()->y);

		$p = new Point('-12,36');
		
		$this->assertEquals(-12, $p->getValue()->x);
		$this->assertEquals(36, $p->getValue()->y);

		$p = new Point('12.0,-36.50');
		
		$this->assertEquals(12.0, $p->getValue()->x);
		$this->assertEquals(-36.5, $p->getValue()->y);
	}

	public function testConstruct7()
	{
		$p = new Point('(12,36)');
		
		$this->assertEquals(12, $p->getValue()->x);
		$this->assertEquals(36, $p->getValue()->y);

		$p = new Point('(   12.0,  36.50)');
		
		$this->assertEquals(12.0, $p->getValue()->x);
		$this->assertEquals(36.5, $p->getValue()->y);

		$p = new Point('( -12 , 36 )');
		
		$this->assertEquals(-12, $p->getValue()->x);
		$this->assertEquals(36, $p->getValue()->y);

		$p = new Point('(12.0        ,-36.50)');
		
		$this->assertEquals(12.0, $p->getValue()->x);
		$this->assertEquals(-36.5, $p->getValue()->y);
	}

	public function testConstruct8()
	{

		$this->setExpectedException(
			'Orms\Type\Exception',
			'Can\'t set a Orms\Type\Point object with the value [Array
(
    [0] => 12
)
]');
		
		$p = new Point(array(12));
	}

	public function testConstruct9()
	{

		$this->setExpectedException(
			'Orms\Type\Exception',
			'Can\'t set a Orms\Type\Point object with the value [Array
(
    [0] => 12
    [1] => GLOU
)
]');
		
		$p = new Point(array(12, 'GLOU'));
	}
}