<?php

namespace Orms\Test;

use Orms\Type\ArrayObject;
use Orms\Type\PgArray;

class PgArrayTest extends \PHPUnit_Framework_TestCase
{
	public function testConstruct1()
	{
		$this->setExpectedException(
			'Orms\Type\Exception',
			'Can\'t create a Orms\Type\PgArray object with a null value.'
		);
	
		$p = new PgArray();
	}

	public function testConstruct2()
	{
		$this->setExpectedException(
			'Orms\Type\Exception',
			'Can\'t set a Orms\Type\PgArray object with the value [Coin]');
		
		$p = new PgArray('Coin');
	}

	public function testConstruct3()
	{
		$this->setExpectedException(
			'Orms\Type\Exception',
			'Can\'t set a Orms\Type\PgArray object with the value [12.5]');
		
		$p = new PgArray(12.5);
	}

	public function testConstruct4()
	{

		$this->setExpectedException(
			'Orms\Type\Exception',
			'Can\'t set a Orms\Type\PgArray object with the value [12]');
		
		$p = new PgArray(12);
	}
	
	public function testConstruct5()
	{
		$p = new PgArray(array(12, 23, 54));
		
		$this->assertEquals(3, $p->getValue()->count());
		$this->assertEquals(12, $p->getValue()->offsetGet(0));
		$this->assertEquals(23, $p->getValue()->offsetGet(1));
		$this->assertEquals(54, $p->getValue()->offsetGet(2));
		
	}
	
	public function testConstruct6()
	{
		$this->setExpectedException(
			'Orms\Type\Exception',
			'Can\'t set a Orms\Type\PgArray object with the value [{glou]'
		);
	
		$p = new PgArray('{glou');
	}

	public function testConstruct7()
	{
		$this->setExpectedException(
			'Orms\Type\Exception',
			'Can\'t set a Orms\Type\PgArray object with the value [glou}]'
		);
	
		$p = new PgArray('glou}');
	}

	public function testConstruct8()
	{
		$p = new PgArray('{}');
		
		$this->assertEquals(0, $p->getValue()->count());
	}
	
	public function testGetValue()
	{
		$p = new PgArray('{COIN,truc}');

		$this->assertInstanceOf('\Orms\Type\PgArray', $p);
		$this->assertEquals(
			new ArrayObject(array('COIN', 'truc')),
			$p->getValue()
		);
		$this->assertEquals('COIN', $p->getValue()->offsetGet(0));
		$this->assertEquals('truc', $p->getValue()->offsetGet(1));

		$ao 	= $p->getValue();
		$ao[] 	= 'Youpi PAN';

		$this->assertEquals(
			new ArrayObject(array('COIN', 'truc', 'Youpi PAN')),
			$p->getValue()
		);
		$this->assertEquals('COIN', $p->getValue()->offsetGet(0));
		$this->assertEquals('truc', $p->getValue()->offsetGet(1));
		$this->assertEquals('Youpi PAN', $p->getValue()->offsetGet(2));

		$this->assertEquals('{COIN,truc,"Youpi PAN"}', $p->__toString());
	}
	
	public function getValueRecursive()
	{
		$p = new PgArray('{{truc,{1,2,3}}},"COIN",PAN');
	
		$this->assertEquals(
			new ArrayObject(array(array('truc',array(1,2,3)), 'COIN', 'PAN')),
			$p->getValue()
		);	
	}

}