<?php

namespace Orms\Proxy\Dumper;

abstract class AbstractMethodDumper
{
    /**
     * @param  \ReflectionMethod $method
     *
     * @return string
     */
    protected function getVisibility(\ReflectionMethod $method)
    {
        if ($method->isPublic()) {
            return 'public';
        }

        if ($method->isProtected()) {
            return 'protected';
        }

        return 'private';
    }

    /**
     * @param \ReflectionParameter[] $parameters
     * @param boolean                $full
     *
     * @return string
     */
    protected function dumpParameters($parameters, $full = true)
    {
        $string = [];

        foreach ($parameters as $parameter) {
            $string[]= $this->dumpParameter($parameter, $full);
        }

        return implode (', ', $string);
    }

    /**
     * @param \ReflectionParameter[] $parameters
     *
     * @return string
     */
    protected function dumpParametersAsArray($parameters)
    {
        $string = [];

        foreach ($parameters as $parameter) {
            $string[]= sprintf('"%s" => $%s', $parameter->name, $parameter->name);
        }

        return sprintf('[%s]', implode (', ', $string));
    }

    /**
     * @param \ReflectionParameter $parameter
     * @param boolean              $full
     *
     * @return string
     */
    protected function dumpParameter($parameter, $full = true)
    {
        if (!$full) {
            return '$'.$parameter->name;
        }

        $defaultValue = $parameter->isDefaultValueAvailable() ? ' = '.var_export($parameter->getDefaultValue(), true) : '';

        $typehint = '';
        if ($parameter->isCallable()) {
            $typehint = 'callable ';
        } elseif ($parameter->isArray()) {
            $typehint = 'array ';
        } elseif ($class = $parameter->getClass()) {
            $typehint = '\\' . $class->name . ' ';
        }

        return $typehint.'$'.$parameter->name.$defaultValue;
    }
}
