<?php

namespace Orms\Proxy;

class Registry
{
    private $classes;

    public function __construct(array $classes = [])
    {
        $this->classes = $classes;
    }

    public function all()
    {
        return $this->classes;
    }

    public function get($name)
    {
        if (!array_key_exists($name, $this->classes)) {
            throw new \DomainException(sprintf('No registered class on "%s" in the registry.', $name));
        }

        return $this->classes[$name];
    }

    public function set($name, $class)
    {
        $this->classes[$name] = $class;

        return $this;
    }

    public function fork()
    {
        return new Registry($this->classes);
    }
}
