<?php

namespace Orms\Proxy\Dumper;

class DirectMethodDumper extends AbstractMethodDumper implements MethodDumperInterface
{
    const METHOD_TEMPLATE = <<<EOF
    private \$%cache%;
    private \$%cache%Flag = false;

    %visibility% function %method% (%arguments%) {
        if (!\$this->%cache%Flag) {
            \$this->%cache% = \$this->registry->get('%service%')->%service_method%(\$this);
            \$this->%cache%Flag = true;
        }

        return \$this->%cache%;
    }
EOF;

    /**
     * @var string
     */
    private $serviceName;

    /**
     * @var string
     */
    private $serviceMethod;

    /**
     * @param string $serviceName
     * @param string $serviceMethod
     */
    public function __construct($serviceName, $serviceMethod)
    {
        $this->serviceName   = $serviceName;
        $this->serviceMethod = $serviceMethod;
    }

    /**
     * {@inheritsDoc}
     */
    public function dump(\ReflectionMethod $method, $configName)
    {
        return str_replace(
            [
                '%cache%',
                '%visibility%',
                '%method%',
                '%arguments%',
                '%service%',
                '%service_method%',
            ],
            [
                $method->name.'Cache',
                $this->getVisibility($method),
                $method->name,
                $this->dumpParameters($method->getParameters()),
                $this->serviceName,
                $this->serviceMethod
            ],
            self::METHOD_TEMPLATE
        );
    }
}
