<?php

namespace Orms\Cache;

use Orms\Cache\CacheKey;

/**
 * CacheInterface must be used to set Cache Driver in ORMs
 *
 * @author Xavier HAUSHERR <xavier.hausherr@ebuzzing.com>
 */
interface CacheInterface
{
    /**
     * Get ORMs cache
     * @param \Orms\Cache\CacheKey $key
     * @return array($result, $metadata)
     */
    public function get(CacheKey $key);

    /**
     * Set ORMs Cache
     * @param \Orms\Cache\CacheKey $key
     * @param mixed $value
     * @param mixed $metadata
     * @return boolean
     */
    public function set(CacheKey $key, $value, $metada);

    /**
     * Delete ORMs cache
     * @param \Orms\Cache\CacheKey $key
     * @return int
     */
    public function clean(CacheKey $key);
}
