<?php

namespace Orms\Test;

require_once(__DIR__ . '/../../Orms/Type/Type.php');
require_once(__DIR__ . '/../../Orms/Type/DateType.php');
require_once(__DIR__ . '/../../Orms/Type/Exception.php');
require_once(__DIR__ . '/../../Orms/Type/Date.php');

use Orms\Type\Date;

class DateTest extends \PHPUnit_Framework_TestCase
{
	public function testConstruct1()
	{
		$this->setExpectedException(
			'Orms\Type\Exception',
			'Can\'t create a Orms\Type\Date object with a null value.'
		);
	
		$d = new Date();
	}

	public function testConstruct2()
	{
		$this->setExpectedException(
			'Orms\Type\Exception',
			'Can\'t set a Orms\Type\Date object with the value [Coin]');
		
		$d = new Date('Coin');
	}

	public function testConstruct3()
	{
		$this->setExpectedException(
			'Orms\Type\Exception',
			'Can\'t set a Orms\Type\Date object with the value [12.5]');
		
		$d = new Date(12.5);
	}

	public function testConstruct4()
	{

		$this->setExpectedException(
			'Orms\Type\Exception',
			'Can\'t set a Orms\Type\Date object with the value [12]');
		
		$d = new Date(12);
	}
	
	public function testConstruct5()
	{
		$this->setExpectedException(
			'Orms\Type\Exception',
			'Can\'t set a Orms\Type\Date object with the value [Array
(
    [0] => 12
)
]'
		);
	
		$d = new Date(array(12));
	}
	
	public function testConstruct8()
	{
		$d = new Date('now');

		$this->assertEquals(date('Y-m-d'), $d->__toString());
	}

	public function testConstruct9()
	{
		$d = new Date('2000-01-01');

		$this->assertEquals(date('2000-01-01'), $d->__toString());
	}
}